//
//  BPURLMessage.h
//  FileDownloader
//
//  Created by Alykhan Jetha on 10-05-06.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface BPURLMessage : NSOperation {
	NSURLConnection *connection;
	NSURLRequest *request;

	NSString *username;
	NSString *password;
	
	NSString *displayMessage; // used by subclassers such as urldownloader

	NSInteger responseStatusCode;
	NSInteger retries;
	
	NSError *error;
	
	id delegate;
}

@property (retain) NSURLConnection *connection;
@property (retain) NSURLRequest *request;
@property (retain) NSString *username;
@property (retain) NSString *password;
@property (retain) NSString *displayMessage;
@property (retain) NSError *error;

@property (assign) NSInteger responseStatusCode;
@property (assign) NSInteger retries;

@property (assign) id delegate;


@end
